<?php
$getSablon = $db->getirTek("sistem_excel_sablonlar", [
    "sablon_id" => $_GET["id"],
]);
if (isset($_POST['sablon_degerler'])) {
    if (!isset($_POST['sablon_adi'])) {
        $errors[] = ["label" => "danger", "message" => "Şablon başlığını kontrol edin."];
    }
    if (isset($errors)) {
        $_SESSION["baf_mesaj"] = $errors;
    } else {
        $sablon = [
            "sablon_baslik" => $_POST['sablon_adi'],
            "sablon_degerler" => json_encode($_POST['sablon_degerler']),
        ];

        try {
            $db->guncelle("sistem_excel_sablonlar", $sablon, [
                "sablon_id" => $_GET["id"]
            ]);
            insertLog(34, $_GET["id"]);
            $errors[] = ["label" => "success", "message" => "Şablon Güncellendi."];
            $_SESSION["baf_mesaj"] = $errors;

            $getSablon = $db->getirTek("sistem_excel_sablonlar", [
                "sablon_id" => $_GET["id"],
            ]);

        } catch (\Exception $e) {

        }
    }

}
?>
<div class="page-body">
    <!-- API plug-in methods table start -->
    <div class="card">
        <form method="post" name="sablon_kaydet">
            <div class="card-block">
                <?php if (isset($_SESSION["baf_mesaj"])): ?>
                    <div class="row">
                        <div class="col-12 mb-3">
                            <?php
                            if (isset($_SESSION['baf_mesaj'])) {
                                foreach ($_SESSION['baf_mesaj'] as $mesaj) {
                                    echo alert($mesaj['label'], $mesaj['message']);
                                    unset($_SESSION['baf_mesaj']);
                                }
                            }
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="row">
                    <div class="col-12">
                        <label for="sablon_adi">Şablon Adı</label>
                        <input type="text" class="form-control" name="sablon_adi" value="<?= $getSablon["sablon_baslik"]; ?>">
                    </div>
                    <div class="col-12">
                        <div class="row">
                            <div class="col-lg-6 col-xl-6">
                                <div class="card-block tab-content p-t-20">
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <h6 class="sub-title">EKLENEBİLEN DEĞERLER</h6>
                                            <select name="eklenebilen_degerler" id="" class="form-control" multiple style="height:300px;">
                                                <option value="sp_musteri">Müşteri Adı</option>
                                                <option value="sp_telefon">Müşteri Telefon</option>
                                                <option value="sp_sehir">Müşteri İl</option>
                                                <option value="sp_ilce">Müşteri İlçe</option>
                                                <option value="sp_il_ilce">Müşteri İl / İlçe</option>
                                                <option value="sp_adres">Müşteri Adres</option>
                                                <option value="sp_odeme_yontemi">Ödeme Yöntemi</option>
                                                <option value="sp_urun_adi">Ürün Adı</option>
                                                <option value="sp_urun_adedi">Ürün Adedi</option>
                                                <option value="sp_urun_secenekleri">Ürün Seçenekleri</option>
                                                <option value="sp_urun_aded_urun_adi">Ürün Adedi + Ürün Adı</option>
                                                <option value="sp_urun_adet_ad_secenekler">Ürün Adedi + Ürün Adı + Seçenekleri</option>
                                                <option value="sp_siparis_tutari">Sipariş Tutarı</option>
                                                <option value="sp_kargo_ucreti">Kargo Ücreti</option>
                                                <option value="sp_kargo">Kargo Firması</option>
                                                <option value="sp_siparis_tutari_kargo_ucreti">Sipariş Tutarı + Kargo Ücreti</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-xl-6">
                                <div class="card-block tab-content p-t-20">
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <h6 class="sub-title">EKLENEN DEĞERLER</h6>
                                            <div class="sol">
                                                <select name="sablon_degerler[]" id="sablon_degerler" class="form-control" multiple style="height:260px;">
                                                    <?php
                                                    if ($getSablon["sablon_degerler"]):
                                                        foreach (json_decode($getSablon["sablon_degerler"]) as $sablonlar) {
                                                            echo "<option value='{$sablonlar}'>" . __lang($sablonlar) . "</option>";
                                                        }
                                                    endif;
                                                    ?>
                                                </select>
                                                <div class="row">
                                                    <div class="col-12 mt-1">
                                                        <button type="button" class="btn btn-primary" name="selectYukari"><i class="fa fa-arrow-up"></i></button>
                                                        <button type="button" class="btn btn-primary" name="selectDelete"><i class="fa fa-times"></i></button>
                                                        <button type="button" class="btn btn-primary" name="selectAsagi"><i class="fa fa-arrow-down"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <button type="button" class="btn btn-success float-right" name="sablonuKaydet">Kaydet</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function (event) {
        $("*[name='selectYukari']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                var newPos = $('select[name="sablon_degerler[]"] option').index(this) - 1;
                if (newPos > -1) {
                    $('select[name="sablon_degerler[]"] option').eq(newPos).before("<option value='" + $(this).val() + "' selected='selected'>" + $(this).text() + "</option>");
                    $(this).remove();
                }
            });
        });

        $("*[name='selectAsagi']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                var newPos = $('select[name="sablon_degerler[]"] option').index(this) + 1;
                if (newPos > -1) {
                    $('select[name="sablon_degerler[]"] option').eq(newPos).after("<option value='" + $(this).val() + "' selected='selected'>" + $(this).text() + "</option>");
                    $(this).remove();
                }
            });
        });

        $("*[name='selectDelete']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                $(this).remove();
            });
        });

        $("button[name='sablonuKaydet']").click(function () {
            $('select[name="sablon_degerler[]"] option').each(function () {
                $(this).prop("selected", true);
            });

            $("form[name='sablon_kaydet']").submit();

        });

    });
</script>