<style>
    .scroll-wrapper {
        overflow-y: hidden;
        overflow-x: scroll
    }

    .scroll-wrapper::-webkit-scrollbar {
        display: none
    }

    .scroll-wrapper {
        white-space: nowrap;
        -webkit-overflow-scrolling: touch;
        width: 100%;
    }


    .card-header {
        padding: .75rem 1.25rem !important;
    }

    h5 {
        margin-bottom: 0;
        color: #333;
        font-size: 15px;
        font-weight: 700;
        display: inline-block;
        margin-right: 10px;
        line-height: 1.1;
        position: relative;
    }

    h5:after {
        content: "";
        background-color: #d2d2d2;
        width: 60px;
        height: 1px;
        position: absolute;
        bottom: -20px;
        left: 0
    }

</style>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="">İşlem Geçmişi</h5>
            </div>
            <div class="card-body">
                <form method="get" action="#">
                    <div class="row mb-2">
                        <div class="col-12 col-md-2 col-sm-2">
                            <label for="">İşlem Yönü</label>
                            <select name="mi_tip" id="mi_tip" class="form-control select2">
                                <option value="" disabled selected>İşlem Yönü</option>
                                <option value="1" <?= (isset($_GET["mi_tip"]) && $_GET["mi_tip"] == 1) ? "selected" : ""; ?>>Gelir</option>
                                <option value="2" <?= (isset($_GET["mi_tip"]) && $_GET["mi_tip"] == 2) ? "selected" : ""; ?>>Gider</option>
                            </select>
                        </div>
                        <div class="col-12 col-md-2 col-sm-2">
                            <label for="mi_tur">İşlem Kategorisi</label>
                            <select name="mi_tur" id="mi_tur" class="form-control select2">
                                <option value="" disabled selected>Kategori Seçin</option>
                                <?php
                                $kategoriler = $db->getir("muhasebe_islem_turleri", null, "mit_baslik asc");
                                foreach ($kategoriler as $kategori):
                                    ?>
                                    <option value="<?= $kategori["mit_id"]; ?>" <?= (isset($_GET["mi_tur"]) && $_GET["mi_tur"] == $kategori["mit_id"]) ? "selected" : ""; ?>><?= $kategori["mit_baslik"]; ?></option>
                                <?php
                                endforeach;
                                ?>
                            </select>
                        </div>
                        <div class="col-12 col-md-2 col-sm-2">
                            <label for="">Proje</label>
                            <select name="mi_proje" id="mi_proje" class="form-control select2">
                                <option value="" disabled selected>Proje Seçin</option>
                                <?php
                                $projeler = $db->getir("projeler", ["pr_durum" => 1], "pr_adi asc");
                                foreach ($projeler as $proje):
                                    ?>
                                    <option value="<?= $proje["pr_id"]; ?>" <?= (isset($_GET["mi_proje"]) && $_GET["mi_proje"] == $proje["pr_id"]) ? "selected" : ""; ?>><?= $proje["pr_adi"]; ?></option>
                                <?php
                                endforeach;
                                ?>
                            </select>
                        </div>
                        <div class="col-6">
                            <br/>
                            <button class="btn palmSplash text-white">Filtrele</button>
                        </div>
                    </div>
                </form>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>İşlem Yönü</th>
                            <th>Kategori</th>
                            <th>Proje</th>
                            <th>Tarih</th>
                            <th>Açıklama</th>
                            <th>Tutar</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        $muhasebeQuery = "select * from muhasebe_islemler as mi join muhasebe_islem_turleri as mit on mi.mi_tur = mit.mit_id where mi.mi_id > 0";
                        if (isset($_GET["mi_tip"]) && $_GET["mi_tip"])
                            $muhasebeQuery .= " and mi_tip = {$_GET["mi_tip"]}";
                        if (isset($_GET["mi_tur"]) && $_GET["mi_tur"])
                            $muhasebeQuery .= " and mi_tur = {$_GET["mi_tur"]}";
                        $muhasebeData = $db->sorguGetir($muhasebeQuery);
                        echo getSayfalama($muhasebeData);
                        $sayfalama = sayfalama($muhasebeData);

                        $muhasebeQuery = "select * from muhasebe_islemler as mi 
                                                            join muhasebe_islem_turleri as mit on mi.mi_tur = mit.mit_id
                                                            left join projeler as pr on pr.pr_id = mi.mi_proje
                                                            where mi.mi_id > 0";
                        if (isset($_GET["mi_tip"]) && $_GET["mi_tip"])
                            $muhasebeQuery .= " and mi_tip = {$_GET["mi_tip"]}";
                        if (isset($_GET["mi_tur"]) && $_GET["mi_tur"])
                            $muhasebeQuery .= " and mi_tur = {$_GET["mi_tur"]}";

                        $muhasebeQuery .= " order by mi.mi_tarih desc limit " . $sayfalama["baslangic"] . "," . _SAYFA_BASI_ICERIK;
                        $muhasebeIslemler = $db->sorguGetir($muhasebeQuery);
                        foreach ($muhasebeIslemler as $mi):
                            ?>
                            <tr>
                                <td><?= $mi["mi_id"]; ?></td>
                                <td><?= ($mi["mi_tip"] == 1) ? "Gelir" : "Gider"; ?></td>
                                <td><?= $mi["mit_baslik"]; ?></td>
                                <td><?= $mi["pr_adi"]; ?></td>
                                <td><?= date("d-m-Y", $mi["mi_tarih"]); ?></td>
                                <td><?= $mi["mi_aciklama"]; ?></td>
                                <td><?= number_format($mi["mi_tutar"], 2, ",", "."); ?> TL</td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                        </tbody>
                    </table>
                    <?php
                    echo getSayfalama($muhasebeData);
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

