<?php
$bugunBas = $carbon::now()->startOfDay()->getTimestamp();
$bugunSon = $carbon::now()->endOfDay()->getTimestamp();

$dunBas = $carbon::yesterday()->startOfDay()->getTimestamp();
$dunSon = $carbon::yesterday()->endOfDay()->getTimestamp();

$buHaftaBas = $carbon::now()->startOfWeek()->getTimestamp();
$buHaftaSon = $carbon::now()->endOfWeek()->getTimestamp();

$buAyBas = $carbon::now()->startOfMonth()->getTimestamp();
$buAySon = $carbon::now()->endOfMonth()->getTimestamp();

$query = "select 
          count(if(sp_tarih between '{$bugunBas}' and '{$bugunSon}',1,null)) as bugun,
          sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as bugun_tutar,
          count(if(sp_tarih between '{$dunBas}' and '{$dunSon}',1,null)) as dun,
          sum(case when sp_tarih between '{$dunBas}' and '{$dunSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as dun_tutar,
          count(if(sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}',1,null)) as buhafta,
          sum(case when sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as buhafta_tutar,
          count(if(sp_tarih between '{$buAyBas}' and '{$buAySon}',1,null)) as buay,
          sum(case when sp_tarih between '{$buAyBas}' and '{$buAySon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as buay_tutar
          from siparisler where sp_durum = 1";

if (!empty($_SESSION['baf_oturum']['k_siteler']))
    $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

$getOzet = $db->sorguGetir($query);
?>
<div class="page-body">
    <div class="row">
        <?php if ($_SESSION['baf_oturum']['kullanici_tipi'] == 1) : ?>
            <div class="col-sm-12">
                <div class="row">
                    <!-- statustic-card start -->
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-block">
                                <div class="row align-items-center">
                                    <div class="col-8">
                                        <h4 class="text-c-green f-w-600"><?= $getOzet[0]["bugun"]; ?></h4>
                                        <h6 class="text-muted m-b-0">Bugünkü Sipariş</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <i class="feather icon-bar-chart f-28"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-c-green">
                                <div class="row align-items-center">
                                    <div class="col-9">
                                        <p class="text-white m-b-0"><?= number_format($getOzet[0]["bugun_tutar"], 2, ",", "."); ?> TL</p>
                                    </div>
                                    <div class="col-3 text-right">
                                        <i class="fa fa-try text-white f-16"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-block">
                                <div class="row align-items-center">
                                    <div class="col-8">
                                        <h4 class="text-c-pink f-w-600"><?= $getOzet[0]["dun"]; ?></h4>
                                        <h6 class="text-muted m-b-0">Dünkü Sipariş</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <i class="feather icon-bar-chart f-28"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-c-pink">
                                <div class="row align-items-center">
                                    <div class="col-9">
                                        <p class="text-white m-b-0"><?= number_format($getOzet[0]["dun_tutar"], 2, ",", "."); ?> TL</p>
                                    </div>
                                    <div class="col-3 text-right">
                                        <i class="fa fa-try text-white f-16"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-block">
                                <div class="row align-items-center">
                                    <div class="col-8">
                                        <h4 class="text-c-blue f-w-600"><?= $getOzet[0]["buhafta"]; ?></h4>
                                        <h6 class="text-muted m-b-0">Bu Hafta</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <i class="feather icon-bar-chart f-28"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-c-blue">
                                <div class="row align-items-center">
                                    <div class="col-9">
                                        <p class="text-white m-b-0"><?= number_format($getOzet[0]["buhafta_tutar"], 2, ",", "."); ?> TL</p>
                                    </div>
                                    <div class="col-3 text-right">
                                        <i class="fa fa-try text-white f-16"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6">
                        <div class="card">
                            <div class="card-block">
                                <div class="row align-items-center">
                                    <div class="col-8">
                                        <h4 class="text-c-yellow f-w-600"><?= $getOzet[0]["buay"]; ?></h4>
                                        <h6 class="text-muted m-b-0">Bu Ay</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <i class="feather icon-bar-chart f-28"></i>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-c-yellow">
                                <div class="row align-items-center">
                                    <div class="col-9">
                                        <p class="text-white m-b-0"><?= number_format($getOzet[0]["buay_tutar"], 2, ",", "."); ?> TL</p>
                                    </div>
                                    <div class="col-3 text-right">
                                        <i class="fa fa-try text-white f-16"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- statustic-card start -->
                    <!-- sale start -->
                    <div class="col-xl-12 scol-md-12">
                        <div class="card table-card">
                            <div class="card-header">
                                <h5>Son 10 Sipariş</h5>
                            </div>
                            <div class="card-block">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th>Ürün</th>
                                            <th>Site</th>
                                            <th>Platform</th>
                                            <th>Şehir</th>
                                            <th>Zaman</th>
                                            <th>-</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $query = "select * from siparisler as sp 
                                                                             join siparisler_urunler as su on sp.sp_id = su.su_siparis_id
                                                                             join urunler_birimler as ub on su.su_birim_id = ub.ub_id
                                                                             join urunler as u on su.su_urun_id = u.urun_id
                                                                             join siteler as st on st.site_id = sp.sp_site
                                                                             left join adres_sehirler as sh on sh.sehir_id = sp.sp_sehir
                                                                             left join siparis_kaynaklari as sk on sk.sk_id = sp.sp_kaynak
                                                                             where sp.sp_durum = 1";

                                        if (!empty($_SESSION['baf_oturum']['k_siteler']))
                                            $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

                                        $query .= " order by sp.sp_id desc limit 0,10";

                                        $son10 = $db->sorguGetir($query);
                                        foreach ($son10 as $sp) :
                                            ?>
                                            <tr>
                                                <td><?= $sp["su_adet"] . " " . $sp["ub_simge"] . " " . $sp["urun_baslik"]; ?></td>
                                                <td><?= $sp["site_url"]; ?></td>
                                                <td><?= ($sp["sk_baslik"]) ? $sp["sk_baslik"] : "-"; ?></td>
                                                <td><?= ($sp["sehir_adi"]) ? $sp["sehir_adi"] : "-"; ?></td>
                                                <td data-toggle="tooltip" data-placement="left" title="<?= date("d-m-Y H:i:s", $sp["sp_tarih"]); ?>"><?= $carbon::parse(date("d-m-Y H:i:s", $sp["sp_tarih"]))->diffForHumans($carbon::now()); ?></td>
                                                <td data-toggle="tooltip" data-placement="left" title="Siparişi İncele">
                                                    <a target="_blank" href="<?= _URL; ?>/siparisler/detay/<?= $sp["sp_id"]; ?>">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right  m-r-20">
                                    <a href="<?= _URL; ?>/siparisler" class="b-b-primary text-primary">Tüm Siparişler</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 scol-md-12">
                        <div class="card table-card">
                            <div class="card-header">
                                <h5>En Çok Satılan Ürünler</h5>
                            </div>
                            <div class="card-block">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th>Ürün</th>
                                            <th>Toplam</th>
                                            <th>Bugün</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $query = "select  urun_baslik,count(sp.sp_id)  as total,
                                                                             sum(sp.sp_siparis_tutari+sp.sp_kargo_ucreti) as total_price,
                                                                             sum(su.su_adet) as total_adet,
                                                                             count(if(sp_tarih between '{$bugunBas}' and '{$bugunSon}',1,null)) as bugun,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as bugun_tutar,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then su.su_adet else 0 end) as bugun_adet
                                                                             from siparisler as sp
                                                                             join siparisler_urunler as su on sp.sp_id = su.su_siparis_id
                                                                             join urunler_birimler as ub on su.su_birim_id = ub.ub_id
                                                                             join urunler as u on su.su_urun_id = u.urun_id
                                                                             join siteler as st on st.site_id = sp.sp_site
                                                                             where sp.sp_durum = 1";
                                        if (!empty($_SESSION['baf_oturum']['k_siteler']))
                                            $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";

                                        $query .= " group by u.urun_id order by total desc limit 0,10";

                                        $son10 = $db->sorguGetir($query);

                                        foreach ($son10 as $sp) :
                                            ?>
                                            <tr>
                                                <td><?= $sp["urun_baslik"]; ?></td>
                                                <td><?= $sp["total"]; ?> / <?= $sp["total_adet"]; ?> / <?= number_format($sp["total_price"], 2, ",", "."); ?> TL</td>
                                                <td><?= $sp["bugun"]; ?> / <?= $sp["bugun_adet"]; ?> / <?= number_format($sp["bugun_tutar"], 2, ",", "."); ?> TL</td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right  m-r-20">
                                    <a href="<?= _URL; ?>/siparisler" class="b-b-primary text-primary">Tümünü Listele</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 scol-md-12">
                        <div class="card table-card">
                            <div class="card-header">
                                <h5>En Çok Sipariş Gelen Site</h5>
                            </div>
                            <div class="card-block">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th>Site</th>
                                            <th>Toplam</th>
                                            <th>Bugün</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $query = "select site_url,
                                                                             count(sp.sp_id)  as total,
                                                                             sum(sp.sp_siparis_tutari+sp.sp_kargo_ucreti) as total_price,
                                                                             sum(su.su_adet) as total_adet,
                                                                             count(if(sp_tarih between '{$bugunBas}' and '{$bugunSon}',1,null)) as bugun,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as bugun_tutar,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then su.su_adet else 0 end) as bugun_adet
                                                                             from siparisler as sp
                                                                             join siparisler_urunler as su on sp.sp_id = su.su_siparis_id
                                                                             join siteler as st on st.site_id = sp.sp_site
                                                                             where sp.sp_durum = 1 ";
                                        if (!empty($_SESSION['baf_oturum']['k_siteler']))
                                            $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
                                        $query .= " group by sp.sp_site order by total desc limit 0,10";
                                        $son10 = $db->sorguGetir($query);
                                        foreach ($son10 as $sp) :
                                            ?>
                                            <tr>
                                                <td><?= $sp["site_url"]; ?></td>
                                                <td><?= $sp["total"]; ?> / <?= $sp["total_adet"]; ?> / <?= number_format($sp["total_price"], 2, ",", "."); ?> TL</td>
                                                <td><?= $sp["bugun"]; ?> / <?= $sp["bugun_adet"]; ?> / <?= number_format($sp["bugun_tutar"], 2, ",", "."); ?> TL</td>
                                                <td></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right  m-r-20">
                                    <a href="<?= _URL; ?>/siparisler" class="b-b-primary text-primary">Tümünü Listele</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 scol-md-12">
                        <div class="card table-card">
                            <div class="card-header">
                                <h5>En Çok Sipariş Gelen Platform</h5>
                            </div>
                            <div class="card-block">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th>Ürün</th>
                                            <th>Toplam Sipariş</th>
                                            <th>Bugün Sipariş</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $query = "select  sk_baslik,count(sp.sp_id)  as total,
                                                                             sum(sp.sp_siparis_tutari+sp.sp_kargo_ucreti) as total_price,
                                                                             sum(su.su_adet) as total_adet,
                                                                             count(if(sp_tarih between '{$bugunBas}' and '{$bugunSon}',1,null)) as bugun,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as bugun_tutar,
                                                                             sum(case when sp_tarih between '{$bugunBas}' and '{$bugunSon}' then su.su_adet else 0 end) as bugun_adet
                                                                             from siparisler as sp 
                                                                             join siparisler_urunler as su on sp.sp_id = su.su_siparis_id
                                                                             join siparis_kaynaklari as sk on sk.sk_id = sp.sp_kaynak
                                                                             where sp.sp_durum = 1 ";
                                        if (!empty($_SESSION['baf_oturum']['k_siteler']))
                                            $query .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
                                        $query .= " group by sp.sp_kaynak order by total desc";
                                        $son10 = $db->sorguGetir($query);
                                        foreach ($son10 as $sp) :
                                            ?>
                                            <tr>
                                                <td><?= $sp["sk_baslik"]; ?></td>
                                                <td><?= $sp["total"]; ?> / <?= $sp["total_adet"]; ?> / <?= number_format($sp["total_price"], 2, ",", "."); ?> TL</td>
                                                <td><?= $sp["bugun"]; ?> / <?= $sp["bugun_adet"]; ?> / <?= number_format($sp["bugun_tutar"], 2, ",", "."); ?> TL</td>
                                                <td></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <!-- sale end -->
    </div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
<div id="styleSelector">

</div>
</div>
</div>