<?php
try {

    $smsModuluKontrol = $db->getir("sistem_moduller", ["modul_tip" => "sms", "modul_durum" => 1]);

    if (!$smsModuluKontrol) {
        echo json_encode([
            "status" => false,
            "message" => "Aktif bir sms modülü bulunmamaktadır."
        ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        exit();
    } else {
    }

    if (!$_POST["sms_telefon"]) {
        echo json_encode([
            "status" => false,
            "message" => "Telefon Numarası Alanı Boş Olamaz."
        ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        exit();
    } elseif (!$_POST["sms_icerik"]) {
        echo json_encode([
            "status" => false,
            "message" => "Mesaj İçeriği Alanı Boş Olamaz."
        ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        exit();
    }

    $db->ekle("smsler", [
        "sms_telefon" => $_POST["sms_telefon"],
        "sms_icerik" => $_POST["sms_icerik"],
        "sms_gonderen" => $_SESSION['baf_oturum']['id'],
        "sms_tarih" => time(),
        "sms_durum" => 0
    ]);

    echo json_encode([
        "status" => true,
        "message" => "SMS Gönderim Sırasına Eklenmiştir."
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
} catch (\Exception $e) {
    echo json_encode([
        "status" => false,
        "message" => "SMS Gönderiminde Bir Sorun Oluştu."
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
}
