<?php

error_reporting(E_ALL);
ini_set('memory_limit', '-1');

require 'vendor/autoload.php';
require 'classes/PHPMailer/PHPMailer.php';
require 'classes/PHPMailer/Exception.php';
require 'classes/PHPMailer/SMTP.php';
require 'classes/Siparisler.php';
require 'classes/Urunler.php';
require 'classes/db.php';
require 'classes/nvi.php';
require 'fonksiyonlar.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;
use Carbon\Carbon;
use Carbon\CarbonPeriod;

session_start();
date_default_timezone_set("Europe/Istanbul");
define("__VERSION", "1.0");
define("__VERSION_KOD", 0120);
define("_DIL", 1);
define("_PANEL_TITLE", "bpanel");
$current_domain = $_SERVER['SERVER_NAME'];
$pageAction = (@$_GET['action']) ? str_replace('/', '', $_GET['action']) : 'home';
$subAction = (@$_GET['sub_action']) ? str_replace('/', '', $_GET['sub_action']) : '';
$pageMethod = (@$_GET['method']) ? str_replace('/', '', $_GET['method']) : '';
require 'ayarlar.php';
require 'yonlendirme.php';
require 'langs.php';


/*
 * Class tanımlamaları
 */
$db = new DB();
$nvi = new NVI();
$sips = new \Siparisler\Siparisler();
$uruns = new \Urunler\Urunler();
$carbon = new Carbon();
$carbonPeriod = new CarbonPeriod();
$carbon::setLocale('tr');

$bugunBas = \Carbon\Carbon::now()->startOfDay()->getTimestamp();
$bugunBit = \Carbon\Carbon::now()->endOfDay()->getTimestamp();

$buHaftaBas = \Carbon\Carbon::now()->startOfWeek()->getTimestamp();
$buHaftaSon = \Carbon\Carbon::now()->endOfWeek()->getTimestamp();

$buAyBas = \Carbon\Carbon::now()->startOfMonth()->getTimestamp();
$buAySon = \Carbon\Carbon::now()->endOfMonth()->getTimestamp();

function _y($metin)
{
    $metin = (isset($metin) ? $metin : "");
    return $metin;
}

// Oturum kontrolü yapıyoruz.
function oturumKontrol()
{
    $oturumId = @$_SESSION['baf_oturum']['id'];
    if (!$oturumId) {
        return false;
    } else {
        return true;
    }
}

function sifrele($text)
{
    return md5(sha1(sha1($text)));
}

function getTitle()
{
    global $pageAction;
    global $pageMethod;
    global $subAction;
    if ($pageAction == "login")
        return __lang("login_title");
    elseif ($pageAction == "home") {
        return __lang("home_title");
    } else {
        if ($pageAction && $subAction && !$pageMethod) {
            return __lang($pageAction . "_" . $subAction);
        } elseif ($pageMethod && $subAction) {
            return __lang($pageAction . "_" . $subAction . "_" . $pageMethod);
        } elseif (!$pageMethod) {
            return __lang($pageAction);
        } else {
            return __lang($pageAction . "_" . $pageMethod);
        }
    }
}

function getIP()
{
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function insertLog($logType, $logKaynak, $logEski = null, $logYeni = null)
{
    global $db;
    $ekle = $db->ekle("loglar", [
        "log_kullanici" => $_SESSION['baf_oturum']['id'],
        "log_type" => $logType,
        "log_kaynak" => $logKaynak,
        "log_eski" => $logEski,
        "log_yeni" => $logYeni,
        "log_tarih" => time(),
        "log_guncelleme" => time(),
        "log_ip" => getIP()
    ]);
    return $ekle;
}

function alert($label, $message)
{
    $alert = '<div class="alert alert-' . $label . ' background-' . $label . '">';
    $alert .= '<button type="button" class="close" data-dismiss="alert" aria-label="Close">';
    $alert .= '</button>';
    $alert .= $message;
    $alert .= '</div>';
    return $alert;
}

function safeWord($word)
{
    $old = [" ", ",", "(", ")"];
    $new = ["_", "_", "_", "_"];
    return str_replace($old, $new, $word);
}

function trToEn($word)
{
    $old = ['ş', 'Ş', 'ı', 'I', 'İ', 'ğ', 'Ğ', 'ü', 'Ü', 'ö', 'Ö', 'Ç', 'ç', '(', ')', '/', ':', ','];
    $new = ['s', 's', 'i', 'i', 'i', 'g', 'g', 'u', 'u', 'o', 'o', 'c', 'c', '', '', '-', '-', ''];
    return str_replace($old, $new, $word);
}

function labels()
{
    $label["palmSplash"] = ["name" => "Palm Splash", "hex" => "#218c74"];
    $label["summerSky"] = ["name" => "Summer Sky", "hex" => "#34ace0"];
    $label["pumpkin"] = ["name" => "Pumpkin", "hex" => "#ff793f"];
    $label["purple"] = ["name" => "Purple", "hex" => "#40407a"];
    $label["porcelain"] = ["name" => "Porcelain", "hex" => "#84817a"];
    $label["newt"] = ["name" => "Newt", "hex" => "#b33939"];
    $label["red"] = ["name" => "Red", "hex" => "#ff5252"];
    $label["tooth"] = ["name" => "Tooth", "hex" => "#d1ccc0"];
    return $label;
}

function getAyarlar()
{
    global $db;
    $ayarlar = $db->getir("ayarlar", null, "a_id asc");
    return $ayarlar;
}

$ayarlar = getAyarlar();

$rapor_haric_durumlar = implode(",", json_decode($ayarlar[16]["a_first_value"]));
$kargodaki_siparis_durumlari = implode(",", json_decode($ayarlar[17]["a_first_value"]));
$teslim_siparis_durumlari = implode(",", json_decode($ayarlar[18]["a_first_value"]));
$iade_siparis_durumlari = implode(",", json_decode($ayarlar[19]["a_first_value"]));
$iptal_siparis_durumlari = implode(",", json_decode($ayarlar[20]["a_first_value"]));
$islemdeki_siparis_durumlari = implode(",", json_decode($ayarlar[21]["a_first_value"]));

define("_SAYFA_BASI_ICERIK", $ayarlar[3]["a_first_value"]);

function sayfalama($data)
{
    $sayfaBasiIcerik = (!empty($_GET["listelenecek_veri"])) ? $_GET["listelenecek_veri"] : _SAYFA_BASI_ICERIK;
    $sayfaSayisi = count($data) / $sayfaBasiIcerik;
    $sayfaSayisi = ceil($sayfaSayisi);
    $baslangic = (@$_GET['sayfa'] > 0) ? @$_GET["sayfa"] * $sayfaBasiIcerik - $sayfaBasiIcerik : @$_GET["sayfa"] * $sayfaBasiIcerik;
    return ["toplam_data" => count($data), "sayfa_sayisi" => $sayfaSayisi, "baslangic" => $baslangic];
}

function getSayfalama($data)
{
    $sayfalama = sayfalama($data);
    $link = "";
    $link .= $_SERVER["REQUEST_URI"];
    //$link = preg_replace("@/sayfa/[0-9]@", "", $link);
    $link = preg_replace("@&sayfa=[0-9]@", "", $link);
    $link = preg_replace("@&sayfa=[0-9]@", "", $link);
    require "views/static/sayfalama.php";
}

function getBafVersiyonlar()
{
    try {
        $gt = curl_init();
        curl_setopt($gt, CURLOPT_URL, "http://bafyazilim.com/baf_versiyonlar.php");
        curl_setopt($gt, CURLOPT_RETURNTRANSFER, 1);
        $res = curl_exec($gt);
        return json_decode($res);
    } catch (\Exception $e) {
        $versiyon["son"] = 0120;
        $versiyon["guncellemeler"][1] = array("no" => "1.0", "tarih" => "15.10.2020", "kod" => 0120);
        return json_decode($versiyon);
    }
}

$lisans_domain = 'tekpanel.site';

$getFile = file_get_contents("app/state.txt");
if ($getFile == "off")
    exit();

function lisansKontrol($domain, $mesaj = null)
{
    global $current_domain;
    global $lisans_domain;

    if ($domain != $current_domain) {
        try {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, "http://metinyildirim.net/bpanel_lisanskontrol.php");
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_ENCODING, "");
            curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
            curl_setopt($curl, CURLOPT_TIMEOUT, 0);
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($curl, CURLOPT_POSTFIELDS, array(
                'lisans_domain' => $lisans_domain,
                'current_domain' => $current_domain,
            ));

            $response = curl_exec($curl);

            curl_close($curl);
        } catch (Exception $e) {
        }
        //exit('lisans hatası');
    }
}

//lisansKontrol($lisans_domain);

$alfabe = [
    1 => "A", 2 => "B", 3 => "C", 4 => "D", 5 => "E", 6 => "F", 7 => "G", 8 => "H", 9 => "I", 10 => "J", 11 => "K", 12 => "L", 13 => "M",
    14 => "N", 15 => "O", 16 => "P", 17 => "Q", 18 => "R", 19 => "S", 20 => "T", 21 => "U", 22 => "V", 23 => "Y", 24 => "Z"
];
