<?php
if (count($_POST)) {
    if ($_POST['sablon_degerler']) {
        $insertKontrol = $db->getirTek("sistem_excel_sablonlar", ["sablon_baslik" => $_POST["sablon_baslik"]]);
        if (!$insertKontrol) {
            $insertDurum = $db->ekle("sistem_excel_sablonlar", ["sablon_baslik" => $_POST["sablon_baslik"], "sablon_degerler" => json_encode($_POST["sablon_degerler"], JSON_UNESCAPED_UNICODE), "sablon_durum" => 1]);
            if ($insertDurum) {
                $insertId = $db->sonEklenen();
                insertLog(10, $insertId);
                $_SESSION['baf_mesaj'][] = ['label' => 'primary', 'message' => 'Excel Şablonu Oluşturuldu'];
            }
        } else {
            $_SESSION['baf_mesaj'][] = ['label' => 'danger', 'message' => 'Bu isimle oluşturulmuş bir excel şablonu var.'];
        }
    }
}
?>
<div class="page-body">
    <div class="row">
        <div class="col-sm-12">
            <!-- Tab variant tab card start -->
            <div class="card">
                <div class="card-block tab-icon">
                    <!-- Row start -->
                    <form method="post" action="#" enctype="multipart/form-data">
                        <input type="hidden" name="act" value="insert">
                        <div class="row">
                            <div class="col-lg-12 col-xl-12">
                                <div class="card-block tab-content p-t-20">
                                    <?php
                                    if (isset($_SESSION['baf_mesaj'])) {
                                        foreach ($_SESSION['baf_mesaj'] as $mesaj) {
                                            echo alert($mesaj['label'], $mesaj['message']);
                                            unset($_SESSION['baf_mesaj']);
                                        }
                                    }
                                    ?>
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <div class="row">
                                                <div class="col-md-12 form-group">
                                                    <label for="sablon_baslik">Şablon Başlığı</label>
                                                    <input type="text" name="sablon_baslik" id="sablon_baslik" class="form-control" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-xl-6">
                                <div class="card-block tab-content p-t-20">
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <h6 class="sub-title">EKLENEBİLEN DEĞERLER</h6>
                                            <select name="eklenebilen_degerler" id="" class="form-control" multiple style="height:300px;">
                                                <option value="sp_musteri">Müşteri Adı</option>
                                                <option value="sp_telefon">Müşteri Telefon</option>
                                                <option value="sp_sehir">Müşteri İl</option>
                                                <option value="sp_ilce">Müşteri İlçe</option>
                                                <option value="">Müşteri İl / İlçe</option>
                                                <option value="">Müşteri Adres</option>
                                                <option value="">Ödeme Yöntemi</option>
                                                <option value="">Ürün Adı</option>
                                                <option value="">Ürün Adedi</option>
                                                <option value="">Ürün Seçenekleri</option>
                                                <option value="">Ürün Adedi + Ürün Adı</option>
                                                <option value="">Ürün Adedi + Ürün Adı + Seçenekleri</option>
                                                <option value="">Sipariş Tutarı</option>
                                                <option value="">Kargo Ücreti</option>
                                                <option value="">Sipariş Tutarı + Kargo Ücreti</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-xl-6">
                                <div class="card-block tab-content p-t-20">
                                    <div class="tab-pane fade active show" id="bg-color" role="tabpanel">
                                        <div class="generic-card-body">
                                            <h6 class="sub-title">EKLENEN DEĞERLER</h6>
                                            <select name="sablon_degerler[]" id="sablon_degerler" class="form-control" multiple style="height:300px;">
                                            </select>
                                            <div class="row">
                                                <div class="col-12 mt-1">
                                                    <button type="button" class="btn btn-primary" name="selectYukari"><i class="fa fa-arrow-up"></i></button>
                                                    <button type="button" class="btn btn-primary" name="selectDelete"><i class="fa fa-times"></i></button>
                                                    <button type="button" class="btn btn-primary" name="selectAsagi"><i class="fa fa-arrow-down"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-danger float-right">
                                    <i class="feather icon-save"></i> Kaydet
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Tab variant tab card start -->
        </div>
    </div>
</div>
</div>
</div>
</div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function (event) {
        $("*[name='selectYukari']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                var newPos = $('select[name="sablon_degerler[]"] option').index(this) - 1;
                if (newPos > -1) {
                    $('select[name="sablon_degerler[]"] option').eq(newPos).before("<option value='" + $(this).val() + "' selected='selected'>" + $(this).text() + "</option>");
                    $(this).remove();
                }
            });
        });

        $("*[name='selectAsagi']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                var newPos = $('select[name="sablon_degerler[]"] option').index(this) + 1;
                if (newPos > -1) {
                    $('select[name="sablon_degerler[]"] option').eq(newPos).after("<option value='" + $(this).val() + "' selected='selected'>" + $(this).text() + "</option>");
                    $(this).remove();
                }
            });
        });

        $("*[name='selectDelete']").click(function () {
            $('select[name="sablon_degerler[]"] option:selected').each(function () {
                $(this).remove();
            });
        });

        $("button[name='sablonuKaydet']").click(function () {
            $('select[name="sablon_degerler[]"] option').each(function () {
                $(this).prop("selected", true);
            });

            $("form[name='sablon_kaydet']").submit();

        });

    });
</script>