<?php
$get = json_decode(json_encode($_GET, true));
?>
<!-- Page-body start -->
<div class="page-body">
    <!-- API plug-in methods table start -->
    <div class="card">
        <div class="card-header"></div>
        <div class="card-block">
            <form action="#" method="get">
                <div class="row">
                    <div class="col-md-12">
                        <h6 class="sub-title">SİPARİŞ FİLTRELEME </h6>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Sipariş NO.</label>
                        <input type="text" class="form-control" name="sp_id"
                               value="<?= (isset($get->sp_id)) ? $get->sp_id : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Müşteri</label>
                        <input type="text" class="form-control" name="sp_musteri"
                               value="<?= (isset($get->sp_musteri)) ? $get->sp_musteri : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Telefon Numarası</label>
                        <input type="text" class="form-control" name="sp_telefon"
                               value="<?= (isset($get->sp_telefon)) ? $get->sp_telefon : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="sp_siparis_durumu">Sipariş Durumu</label>
                        <select name="sp_siparis_durumu" id="sp_siparis_durumu" class="form-control">
                            <option value="" disabled selected>Sipariş Durumu</option>
                            <?php
                            $sip_durum = $db->getir("siparis_durumlari", ["durum_durum" => 1], "durum_baslik asc");
                            foreach ($sip_durum as $durum) {
                                $durumSelected = (isset($_GET["sp_siparis_durumu"]) && $_GET["sp_siparis_durumu"] == $durum["durum_id"]) ? "selected" : "";
                                echo "<option value='{$durum["durum_id"]}' {$durumSelected}>{$durum["durum_baslik"]}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="urun_id">Ürün</label>
                        <select name="urun_id" id="urun_id" class="form-control">
                            <option value="" disabled selected>Ürün</option>
                            <?php
                            $urunler = $db->getir("urunler", ["urun_durum" => 1], "urun_baslik asc");
                            foreach ($urunler as $urun) {
                                $urunSelected = (isset($_GET["urun_id"]) && $_GET["urun_id"] == $urun["urun_id"]) ? "selected" : "";
                                echo "<option value='{$urun["urun_id"]}' {$urunSelected}>{$urun["urun_baslik"]}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="urun_id">Sipariş Kaynağı</label>
                        <select name="sp_kaynak" id="sp_siparis_kaynagi" class="form-control">
                            <option value="" disabled selected>Sipariş Kaynağı</option>
                            <?php
                            $spkaynaklari = $db->getir("siparis_kaynaklari", null, "sk_baslik asc");
                            foreach ($spkaynaklari as $spkaynak) {
                                $spkSelected = (isset($_GET["sp_siparis_kaynagi"]) && $_GET["sp_siparis_kaynagi"] == $spkaynak["sk_id"]) ? "selected" : "";
                                echo "<option value='{$spkaynak["sk_id"]}' {$spkSelected}>{$spkaynak["sk_baslik"]}</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="sp_siparis_durumu">Listelenecek Veri</label>
                        <input type="text" class="form-control" name="listelenecek_veri"
                               value="<?= (isset($get->listelenecek_veri)) ? $get->listelenecek_veri : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="sp_tarih_ilk">İlk Sipariş Tarihi</label>
                        <input type="date" class="form-control" name="sp_tarih_ilk"
                               value="<?= (isset($get->sp_tarih_ilk)) ? $get->sp_tarih_ilk : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="sp_tarih_son">Son Sipariş Tarihi</label>
                        <input type="date" class="form-control" name="sp_tarih_son"
                               value="<?= (isset($get->sp_tarih_son)) ? $get->sp_tarih_son : ""; ?>">
                    </div>
                    <div class="col-md-2 form-group">
                        <label for="">Müşteri IP</label>
                        <input type="text" class="form-control" name="sp_musteri_ip"
                               value="<?= (isset($get->sp_musteri_ip)) ? $get->sp_musteri_ip : ""; ?>">
                    </div>
                    <div class="col-md-12 form-group">
                        <button class="btn btn-danger float-right"><i class="feather icon-search"></i> Filtrele</button>
                    </div>
                </div>
            </form>

            <div class="table-responsive">
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $siparislerSayfa = $sips->getSiparislerCount();
                        $sayfalama = sayfalama($siparislerSayfa);
                        $siparisler = $sips->getSiparisler(null, $sayfalama["baslangic"]);
                        getSayfalama($siparislerSayfa);
                        ?>
                    </div>
                    <div class="col-md-6">
                        <button class="btn pumpkin float-right text-white btnew" name="excel_olustur"
                                onclick="siparisExcelOlustur()"
                                value='<?= json_encode($_GET, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>'>
                            Excel Oluştur
                        </button>
                        
                        <button class="btn red text-white float-right mr-1" name="siparisler_toplu_islemler"
                                onclick="cokluDuzenlemePanel()">Toplu Düzenleme
                        </button>
                    </div>
                </div>
                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th><input type="checkbox" name="hepsini_sec"/></th>
                        <th>#</th>
                        <th></th>
                        <th>MÜŞTERİ</th>
                        <th>SİPARİŞ BİLGİLERİ</th>
                        <th>SİPARİŞ DURUMU</th>
                        <th>SİPARİŞ KAYNAĞI</th>
                        <th>SİPARİŞ TARİHİ</th>
                        
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    if (!$siparisler["data"]) :
                        echo "<tr><td align='center' colspan='7'>Veri Bulunamadı</td></tr>";
                    endif;
                    foreach ($siparisler["data"] as $sip) :
                        $spNot = '';
                        $trClass = '';
                        if (isset($sip["mukerrer"]) && $sip["mukerrer"] > 1) {
                            $spNot .= '';
                            $trClass .= 'soft-red text-white';
                        }
                        ?>
                        <tr id="<?= $sip["sp_id"]; ?>" class="<?= $trClass; ?>">
                            <td><input type="checkbox" name="siparisler_chkbx[]" value="<?= $sip["sp_id"]; ?>"/></td>
                            <td><?= $sip["sp_id"]; ?></td>
                            <td style="max-width: 175px;">
                                <div>
                                    <a href="<?= _URL; ?>/siparisler/detay/<?= $sip["sp_id"]; ?>" target="_blank">
                                        <button class="btn btn-primary btn-sm">İncele</button>
                                    </a>
                                    <?php 
                                            $sipKontrol = "select * from siparisler where sp_id not in ({$sip["sp_id"]}) and sp_telefon like '%{$sip["sp_telefon"]}%'";
                                            $sipKontrolGet = $db->sorguGetir($sipKontrol);
                                        if($sip["durum_baslik"] == "Yeni Sipariş") {
                                            ?>
                                            <button class="btn btn-success btn-sm" onclick="onaylaSiparis(<?= $sip['sp_id']; ?>)">Onayla</button>
                                    <?php
                                            if (count($sipKontrolGet)) {
                                                echo "<div style='padding-top: 5px;'><a class='btn btn-danger btn-sm' href='" . _URL . "/siparisler?sp_telefon={$sip["sp_telefon"]}'><i class='fa fa-search'></i> Mükerrer İncele</a></div>";
                                            } } ?>
                                </div>
                            </td>
                            <td>
                                <?= substr($sip["sp_musteri"], 0, 50); ?><br/>
                                <?php if (isset($sip["mukerrer"]) && $sip["mukerrer"] > 1):
                                    $otherSips = explode(",", $sip["other_sips"]);
                                    foreach ($otherSips as $os):
                                        ?>
                                        <a href="<?= _URL; ?>/siparisler/detay/<?= $os; ?>" target="_blank">
                                            <span class="label red"><?= $os; ?></span>
                                        </a>
                                    <?php endforeach;
                                    echo '<br />'; endif; ?>
                                <small><?= $sip["sp_telefon"]; ?> <br/><?= $sip["sp_musteri_ip"]; ?></small>
                            </td>
                            <td style="overflow: auto; max-width:300px;">
                                <?= $sip["su_adet"]; ?> <?= $sip["ub_baslik"]; ?> <?= $sip["urun_baslik"]; ?> - <?= $sip["sp_siparis_tutari"]; ?>₺<br/>
                                <small><?= $sip["site_url"]; ?><?= (!empty($sip["sk_baslik"]) ? ' - ' . $sip["sk_baslik"] : ''); ?></small><br/>
                                <small><?= $sip["sp_adres"]; ?></small>
                            </td>
                            <td>
                                <span class="label <?= $sip["durum_etiket"]; ?>"><?= $sip["durum_baslik"]; ?></span>
                            </td>
                            <td>
                                <?php
                                    $spkaynaklari2 = $db->getir("siparis_kaynaklari", null, "sk_baslik asc");
                                    foreach ($spkaynaklari2 as $spkaynak2) {
                                        if ($sip["sp_kaynak"] == $spkaynak2["sk_id"]) {
                                            echo "<span>{$spkaynak2["sk_baslik"]}</span>";
                                        }
                                    }
                                ?>
                                <span class="label <?= $sip["sp_kaynak"]; ?>"><?= $sip["sp_kaynak"]; ?></span>
                            </td>
                            <td data-toggle="tooltip" data-placement="left"
                                title="<?= date("d-m-Y H:i:s", $sip["sp_tarih"]); ?>">
                                <?= $carbon::parse(date("d-m-Y H:i:s", $sip["sp_tarih"]))->diffForHumans($carbon::now()); ?>
                                <p><?= date("d-m-Y H:i:s", $sip["sp_tarih"]); ?></p>
                            </td>
                            
                        </tr>
                    <?php
                    endforeach;
                    ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th><input type="checkbox" name="hepsini_sec"/></th>
                        <th>#</th>
                        <th>MÜŞTERİ</th>
                        <th>SİPARİŞ BİLGİLERİ</th>
                        <th>SİPARİŞ DURUMU</th>
                        <th>SİPARİŞ TARİHİ</th>
                        <th></th>
                    </tr>
                    </tfoot>
                </table>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        echo getSayfalama($siparislerSayfa);
                        echo $sayfalama["toplam_data"] . " adetten " . count($siparisler["data"]) . " adet gösteriliyor.";
                        ?>
                    </div>
                    <div class="col-md-6">
                        <button class="btn pumpkin text-white float-right" name="excel_olustur"
                                onclick="siparisExcelOlustur()"
                                value='<?= json_encode($_GET, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>'>
                            Excel Oluştur
                        </button>
                        <button class="btn red text-white float-right mr-1" name="siparisler_toplu_islemler"
                                onclick="cokluDuzenlemePanel()">ÇOKLU DÜZENLEME
                        </button>
                    </div>
                </div>
                <script>
                    function onaylaSiparis(sp_id) {
                        if (confirm("Siparişi onaylamak istiyor musunuz?")) {
                            $.post(baseUrl + "/ajax/hizliSiparisGuncelle", {
                                sp_id: sp_id,
                                sp_siparis_durumu: 2
                            }).done(function (e) {
                                var cevap = $.parseJSON(e);
                                $.each(cevap, function (index, sonuc) {
                                    alertGet(sonuc.durum, sonuc.baslik, sonuc.icerik);
                                    if (sonuc.durum === "success") {
                                        location.reload(); // başarı durumunda sayfayı yenileyebilirsin
                                    }
                                });
                            }).fail(function () {
                                alert("Sunucuya bağlanılamadı.");
                            });
                        }
                    }
                </script>
            </div>
        </div>
    </div>
</div>
<!-- Page-body start -->
</div>
</div>
</div>
</div>