<style>
    .scroll-wrapper {
        overflow-y: hidden;
        overflow-x: scroll
    }

    .scroll-wrapper::-webkit-scrollbar {
        display: none
    }

    .scroll-wrapper {
        white-space: nowrap;
        -webkit-overflow-scrolling: touch;
        width: 100%;
    }

    .dragscroll {
        overflow: hidden;
    }

    .main-body .page-wrapper {
        padding: 0px;
    }

    .card-header {
        padding: .75rem 1.25rem !important;
    }

    h5 {
        margin-bottom: 0;
        color: #333;
        font-size: 15px;
        font-weight: 700;
        display: inline-block;
        margin-right: 10px;
        line-height: 1.1;
        position: relative;
    }

    h5:after {
        content: "";
        background-color: #d2d2d2;
        width: 60px;
        height: 1px;
        position: absolute;
        bottom: -20px;
        left: 0
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="scroll-wrapper dragscroll">
            <?php
            $getDurumSipQry = "SELECT count(sp_id) as sp_total, durum_id, durum_baslik, durum_etiket FROM siparisler AS sp JOIN siparis_durumlari AS sd ON sp.sp_siparis_durumu = sd.durum_id WHERE sp.sp_siparis_durumu NOT IN ({$rapor_haric_durumlar}) AND sp.sp_durum = 1 ";
            
            if (!empty($_SESSION['baf_oturum']['k_siteler'])) $getDurumSipQry .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
            $getDurumSipQry .= " GROUP BY sp.sp_siparis_durumu ORDER BY sp_total DESC";
            $getDurumSips = $db->sorguGetir($getDurumSipQry);
            foreach ($getDurumSips as $get) :
            ?>
                <a href="<?= _URL; ?>/siparisler/durum/<?= $get["durum_id"]; ?>">
                    <button class="btn btn-sm <?= $get["durum_etiket"]; ?> text-white">
                        <i class="fa fa-list"></i>
                        <?= $get["durum_baslik"]; ?>
                        <span class="btn-count"><?= $get["sp_total"]; ?></span>
                    </button>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<hr />
<style>
    table th {
        line-height: 20px;
    }

    .col {
        width: 10%;
    }

    table {
        border-collapse: inherit;
        border-spacing: 0 1em;
    }

    .table thead th {
        border: 0px;
    }

    .col-4>p {
        margin-bottom: 0.5rem;
    }
</style>
<div class="row">
    <div class="col-7">
        <div class="card">
            <div class="card-header">
                <h5 class="">Sipariş Karşılaştırma</h5>
                <small class="">
                    <input class="btn-count" type="text" id="dateRangeBygetHomeKarsilastirma" name="dateRangeBygetHomeKarsilastirma" />
                </small>
            </div>
            <div class="card-body">
                <canvas id="getHomeKarsilastirma" height="100"></canvas>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-5 col-lg-5">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="">Satış Özeti</h5>
                    </div>
                    <div class="card-body">
                        <?php
                        $ozetQuery = "SELECT";
                        $ozetQuery .= " kur_id,kur_simge,kur_tl_deger, count(if(sp_tarih between '{$bugunBas}' and '{$bugunBit}' and sp_durum = 1,1,null)) as bugun_sp, 
                        sum(case when sp_tarih between '{$bugunBas}' and '{$bugunBit}' and sp_durum = 1 then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as bugun_sp_tutar,
                        sum(case when sp_tarih between '{$bugunBas}' and '{$bugunBit}' and sp_durum = 1 then su_adet else 0 end) as bugun_sp_urun,
                        count(if(sp_tarih between '{$bugunBas}' and '{$bugunBit}' and sp_siparis_durumu = 5 and sp_durum = 1,1,null)) as bugun_sp_onay,";
                        $ozetQuery .= " count(if(sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}' and sp_durum = 1,1,null)) as buhafta_sp,
                        sum(case when sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}' and sp_durum = 1 then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as buhafta_sp_tutar, 
                        sum(case when sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}' and sp_durum = 1 then su_adet else 0 end) as buhafta_sp_urun,
                        count(if(sp_tarih between '{$buHaftaBas}' and '{$buHaftaSon}' and sp_siparis_durumu = 5 and sp_durum = 1,1,null)) as buhafta_sp_onay,";
                        $ozetQuery .= " count(if(sp_tarih between '{$buAyBas}' and '{$buAySon}' and sp_durum = 1,1,null)) as buay_sp, 
                        sum(case when sp_tarih between '{$buAyBas}' and '{$buAySon}' and sp_durum = 1 then sp_siparis_tutari+sp_kargo_ucreti else 0 end) as buay_sp_tutar, 
                        sum(case when sp_tarih between '{$buAyBas}' and '{$buAySon}' and sp_durum = 1 then su_adet else 0 end) as buay_sp_urun,
                        count(if(sp_tarih between '{$buAyBas}' and '{$buAySon}' and sp_siparis_durumu = 5 and sp_durum = 1,1,null)) as buay_sp_onay";
                        $ozetQuery .= " FROM siparisler";
                        $ozetQuery .= " JOIN siparisler_urunler ON sp_id = su_siparis_id";
                        $ozetQuery .= " LEFT JOIN kurlar ON sp_kur = kur_id";
                        $ozetQuery .= " WHERE sp_siparis_durumu NOT IN ({$rapor_haric_durumlar}) AND sp_durum = 1 AND su_durum = 1";
                        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $ozetQuery .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
                        $ozetQuery .= "  GROUP BY sp_kur";
                        $satisOzeti = $db->sorguGetir($ozetQuery);

                        //Secho "<pre>";
                        //Sprint_r($satisOzeti);
                        //Secho "</pre>";

                        $totalSiparisBugun = 0;
                        $totalAdetBugun = 0;
                        $bugunToplamCiro = 0;

                        $totalSiparisBuhafta = 0;
                        $totalAdetBuHafta = 0;
                        $buHaftaToplamCiro = 0;

                        $totalSiparisBuAy = 0;
                        $totalAdetBuAy = 0;
                        $buAyToplamCiro = 0;
                        
                        $buGunOrtalamaOran = 0.00;
                        $buHaftaOrtalamaOran = 0.00;
                        $buAyOrtalamaOran = 0.00;


                        foreach ($satisOzeti as $so) {
                            $totalSiparisBugun += $so["bugun_sp"];
                            $totalAdetBugun += $so["bugun_sp_urun"];
                            $kurTotalPriceBugun = $so["bugun_sp_tutar"];
                            $kurTlPriceBugun = $so["kur_tl_deger"] * $kurTotalPriceBugun;
                            $bugunToplamCiro += $kurTlPriceBugun;

                            $totalSiparisBuhafta += $so["buhafta_sp"];
                            $totalAdetBuHafta += $so["buhafta_sp_urun"];
                            $kurTotalPriceBuHafta = $so["buhafta_sp_tutar"];
                            $kurTlPriceHafta = $so["kur_tl_deger"] * $kurTotalPriceBuHafta;
                            $buHaftaToplamCiro += $kurTlPriceHafta;

                            $totalSiparisBuAy += $so["buay_sp"];
                            $totalAdetBuAy += $so["buay_sp_urun"];
                            $kurTotalPriceBuAy = $so["buay_sp_tutar"];
                            $kurTlPriceAy = $so["kur_tl_deger"] * $kurTotalPriceBuAy;
                            $buAyToplamCiro += $kurTlPriceAy;
                            
                            $totalOnayBuGun += $so["bugun_sp_onay"];
                            $totalOnayBuHafta += $so["buhafta_sp_onay"];
                            $totalOnayBuAy += $so["buay_sp_onay"];
                        }
                        
                        $bugunOrtalamaTutar = $totalSiparisBugun > 0 ? $bugunToplamCiro / $totalSiparisBugun : 0;
                        $buHaftaOrtalamaTutar = $totalSiparisBuhafta > 0 ? $buHaftaToplamCiro / $totalSiparisBuhafta : 0;
                        $buAyOrtalamaTutar = $totalSiparisBuAy > 0 ? $buAyToplamCiro / $totalSiparisBuAy : 0;
                        
                        $buGunOrtalamaOran = $totalSiparisBugun > 0 ? ($totalOnayBuGun / $totalSiparisBugun) * 100 : 0;
                        $buHaftaOrtalamaOran = $totalSiparisBuhafta > 0 ? ($totalOnayBuHafta / $totalSiparisBuhafta) * 100 : 0;
                        $buAyOrtalamaOran = $totalSiparisBuAy > 0 ? ($totalOnayBuAy / $totalSiparisBuAy) * 100 : 0;

                        /*
                        */
                        ?>
                        <div class="row">
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Bugün Satış</b><br />
                                    <b class="text-red"><?= $totalSiparisBugun; ?></b><br />
                                    <b>Ortalama: <?= number_format($bugunOrtalamaTutar, 2, ".", ","); ?> TL</b><br />
                                    <b style="color: red; font-size:12px;">Kargoda: %<?= number_format($buGunOrtalamaOran, 2, ".", ","); ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ürün Sayısı</b><br />
                                    <b class="text-red"><?= $totalAdetBugun; ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ciro</b><br />
                                    <b class="text-red"><?= number_format($bugunToplamCiro, 2, ".", ","); ?> TL</b>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Bu Hafta Sipariş</b><br />
                                    <b class="text-red"><?= $totalSiparisBuhafta; ?></b><br />
                                    <b>Ortalama: <?= number_format($buHaftaOrtalamaTutar, 2, ".", ","); ?> TL</b><br />
                                    <b style="color: red; font-size:12px;">Kargoda: %<?= number_format($buHaftaOrtalamaOran, 2, ".", ","); ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ürün Sayısı</b><br />
                                    <b class="text-red"><?= $totalAdetBuHafta; ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ciro</b><br />
                                    <b class="text-red"><?= number_format($buHaftaToplamCiro, 2, ".", ","); ?> TL</b>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Bu Ay Sipariş</b><br />
                                    <b class="text-red"><?= $totalSiparisBuAy; ?></b><br />
                                    <b>Ortalama: <?= number_format($buAyOrtalamaTutar, 2, ".", ","); ?> TL</b><br />
                                    <b style="color: red; font-size:12px;">Kargoda: %<?= number_format($buAyOrtalamaOran, 2, ".", ","); ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ürün Sayısı</b><br />
                                    <b class="text-red"><?= $totalAdetBuAy; ?></b>
                                </p>
                            </div>
                            <div class="col-4">
                                <p class="text-left">
                                    <b>Ciro</b><br />
                                    <b class="text-red"><?= number_format($buAyToplamCiro, 2, ".", ","); ?> TL</b>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="card-header">
                        <h5 class="">Son Siparişler</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12" style="max-height: 150px; min-height: 150px; overflow-y: scroll;">
                                <table class="table" style="border-spacing: 0 0em">
                                    <thead>
                                        <tr>
                                            <th scope="col">Sipariş No</th>
                                            <th scope="col">Müşteri</th>
                                            <th scope="col">Sipariş Tutarı</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sonQuery = "SELECT * FROM siparisler LEFT JOIN kurlar ON sp_kur = kur_id WHERE sp_siparis_durumu NOT IN ({$rapor_haric_durumlar}) AND sp_durum = 1";
                                        if (!empty($_SESSION['baf_oturum']['k_siteler'])) $sonQuery .= " and sp_site in ({$_SESSION['baf_oturum']['k_siteler']})";
                                        $sonQuery .= " ORDER BY sp_tarih DESC LIMIT 0,10";
                                        $sonSiparisler = $db->sorguGetir($sonQuery);
                                        foreach ($sonSiparisler as $siparis) :
                                            $kurluTutar = $siparis["kur_tl_deger"] * ($siparis["sp_siparis_tutari"] + $siparis["sp_kargo_ucreti"]);
                                        ?>
                                            <tr style="border-bottom:1px solid #dbdbdb">
                                                <td>
                                                    <a target="_blank" href="<?= _URL; ?>/siparisler/detay/<?= $siparis["sp_id"]; ?>">
                                                        <b class="text-red">SP<?= $siparis["sp_id"]; ?></b>
                                                    </a>
                                                </td>
                                                <td><?= $siparis["sp_musteri"]; ?></td>
                                                <td><?= number_format($kurluTutar, 2, ".", ","); ?> TL</td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>