<?php

// 2 olan siparişleri çek
$siparisler = $db->getir("siparisler", ["sp_siparis_durumu" => 2]);

$sonuc = [];

if ($siparisler) {
    foreach ($siparisler as $siparis) {
        $sip_id = $siparis["sp_id"];
        try {
            $db->guncelle("siparisler", ["sp_siparis_durumu" => 14], ["sp_id" => $sip_id]);
            $sonuc[] = ["durum" => "success", "baslik" => "Güncellendi", "icerik" => "#{$sip_id} -> 14 yapıldı"];
        } catch (Exception $e) {
            $sonuc[] = ["durum" => "error", "baslik" => "Hata", "icerik" => "#{$sip_id} güncellenemedi: " . $e->getMessage()];
        }
    }
} else {
    $sonuc[] = ["durum" => "info", "baslik" => "İşlem Yok", "icerik" => "Durumu 2 olan sipariş bulunamadı."];
}

echo json_encode($sonuc, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
