<?php
require 'app/all.php';
define("DIR", __DIR__);
define("VIEWS", __DIR__ . "/views/");
try {
    if ($pageAction == 'home') {
        require 'views/static/header.php';
        require 'views/home.php';
        require 'views/static/footer.php';
    } elseif ($pageAction == "ajax") {
        require "views/ajax/" . $pageMethod . ".php";
    } elseif ($pageAction == "chartjs") {
        require "views/chartjs/" . $pageMethod . ".php";
    } elseif ($pageAction == "cron") {
        require "views/cron/" . $pageMethod . ".php";
    } elseif ($pageAction == "excel") {
        require "views/excel/" . $pageMethod . ".php";
    } elseif ($pageAction == "islem") {
        require "views/islem/" . $pageMethod . ".php";
    } elseif ($pageAction && $pageMethod && !$subAction) {
        require 'views/static/header.php';
        if (file_exists('views/pages/' . $pageAction . '/' . $pageMethod . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $pageMethod . '.php';
        } elseif (file_exists('views/pages/' . $pageAction . '/' . $pageMethod . '/' . $pageMethod . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $pageMethod . '/' . $pageMethod . '.php';
        } else {
            echo 'views/pages/' . $pageAction . '/' . $pageMethod . '.php';
            require 'views/static/error.php';
        }
        require 'views/static/footer.php';
    } elseif ($pageAction == "bot" && $subAction && !in_array($pageAction, ['login', 'logout'])) {
        // Bot controller
        if (file_exists('views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php';
        } else {
            echo 'views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php';
            require 'views/static/error.php';
        }
    } elseif ($pageAction && $subAction && !in_array($pageAction, ['login', 'logout'])) {
        require 'views/static/header.php';
        if (file_exists('views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php';
        } elseif (!$pageMethod && ('views/pages/' . $pageAction . '/' . $subAction . '/' . $subAction . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $subAction . '/' . $subAction . '.php';
        } else {
            echo 'views/pages/' . $pageAction . '/' . $subAction . '/' . $pageMethod . '.php';
            require 'views/static/error.php';
        }
        require 'views/static/footer.php';
    } elseif ($pageAction && !in_array($pageAction, ['login', 'logout'])) {
        require 'views/static/header.php';
        if (file_exists('views/pages/' . $pageAction . '/' . $pageAction . '.php')) {
            require 'views/pages/' . $pageAction . '/' . $pageAction . '.php';
        } else {
            echo 'views/pages/' . $pageAction . '/' . $pageAction . '.php';
            require 'views/static/error.php';
        }
        require 'views/static/footer.php';
    } elseif ($pageAction == 'login') {
        require 'views/login.php';
    } elseif ($pageAction == 'logout') {
        require 'views/logout.php';
    }
} catch (Exception $e) {
    echo $e;
}
