<?php

namespace VatanSms;

use DB;

class VatanSms
{
    const modul_adi = "Vatan SMS Sms Entegrasyonu";
    const modul_aciklama = "Vatan SMS SMS Entegrasyonu.";
    const modul_kod = "vatan_sms";
    const modul_tip = "sms";
    const gerekli_alanlar = [
        ["alan_adi" => "api_kullanici_adi", "alan_title" => "API Kullanıcı Adı"],
        ["alan_adi" => "api_sifre", "alan_title" => "API Şifre"],
        ["alan_adi" => "api_sms_basligi", "alan_title" => "SMS Başlığı"],
    ];
    const donus_kodlari = [
        00 => "Görevinizin tarih formatinda bir hata olmadığını gösterir",
        01 => "Mesaj gönderim baslangıç tarihinde hata var. Sistem tarihi ile değiştirilip işleme alındı.",
        02 => "Mesaj gönderim sonlandırılma tarihinde hata var.Sistem tarihi ile değiştirilip işleme alındı.Bitiş tarihi başlangıç tarihinden küçük girilmiş ise, sistem bitiş tarihine içinde bulunduğu tarihe 24 saat ekler.",
        20 => "Mesaj metninde ki problemden dolayı gönderilemediğini veya standart maksimum mesaj karakter sayısını geçtiğini ifade eder. (Standart maksimum karakter sayısı 917 dir. Eğer mesajınız türkçe karakter içeriyorsa Türkçe Karakter Hesaplama menüsunden karakter sayılarının hesaplanış şeklini görebilirsiniz.)",
        30 => "Geçersiz kullanıcı adı , şifre veya kullanıcınızın API erişim izninin olmadığını gösterir.Ayrıca eğer API erişiminizde IP sınırlaması yaptıysanız ve sınırladığınız ip dışında gönderim sağlıyorsanız 30 hata kodunu alırsınız. API erişim izninizi veya IP sınırlamanızı , web arayüzden; sağ üst köşede bulunan ayarlar> API işlemleri menüsunden kontrol edebilirsiniz.",
        40 => "Mesaj başlığınızın (gönderici adınızın) sistemde tanımlı olmadığını ifade eder. Gönderici adlarınızı API ile sorgulayarak kontrol edebilirsiniz.",
        50 => "Abone hesabınız ile İYS kontrollü gönderimler yapılamamaktadır.",
        51 => "Aboneliğinize tanımlı İYS Marka bilgisi bulunamadığını ifade eder.",
        70 => "Hatalı sorgulama. Gönderdiğiniz parametrelerden birisi hatalı veya zorunlu alanlardan birinin eksik olduğunu ifade eder.",
        85 => "Mükerrer Gönderim sınır aşımı. Aynı numaraya 1 dakika içerisinde 20'den fazla görev oluşturulamaz.",
        109 => "SMS Gönderilemedi"
    ];

    public static function Kurulum()
    {
        global $db;
        echo "Kurulum başlıyor...";
        $modul["modul_tip"] = "sms";
        $modul["modul_kodu"] = "vatan_sms";
        $modul["modul_adi"] = "Vatan SMS Sms Entegrasyonu";
        $modul["modul_dir"] = "VatanSms.php";
        $modul["modul_durum"] = 1;
        $modulKurulumKontrol = $db->getirTek("sistem_moduller", ["modul_kodu" => $modul["modul_kodu"]]);
        if ($modulKurulumKontrol) {
            echo "<br />Modül kurulumu zaten yapılmış.";
        } else {
            $insertModul = $db->ekle("sistem_moduller", $modul);

            $db->sorguGetir("CREATE TABLE IF NOT EXISTS `modul_vatan_sms_ayarlar` (
                                 `an_id` int(11) NOT NULL AUTO_INCREMENT,
                                 `an_baslik` varchar(250) NOT NULL,
                                 `an_kod` varchar(250) DEFAULT NULL,
                                 `an_deger` varchar(250) DEFAULT NULL,
                                 `an_tip` varchar(250) DEFAULT NULL,
                                 PRIMARY KEY (`an_id`)
                                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            if ($insertModul) {
                echo "<br />Modül verileri oluşturuldu...";
            }
        }
    }

    public function Ayarlar()
    {
        global $db;

        if (!empty($_POST["api_kullanici_adi"]) && !empty($_POST["api_sifre"])) {

            $api_kullanici_adi_kontrol = $db->getirTek("modul_vatan_sms_ayarlar", ["an_tip" => "api_bilgileri"]);

            $apiBilgileri = [
                "api_kullanici_adi" => $_POST["api_kullanici_adi"],
                "api_sifre" => $_POST["api_sifre"],
                "api_sms_basligi" => $_POST["api_sms_basligi"],
            ];

            if (empty($api_kullanici_adi_kontrol)) {
                $db->ekle("modul_vatan_sms_ayarlar", ["an_baslik" => "API Bilgileri", "an_kod" => 1, "an_deger" => json_encode($apiBilgileri, JSON_FORCE_OBJECT), "an_tip" => "api_bilgileri"]);
            } else {
                $db->guncelle("modul_vatan_sms_ayarlar", ["an_deger" => json_encode($apiBilgileri, JSON_FORCE_OBJECT)], ["an_tip" => "api_bilgileri"]);
            }
        }

        $getApiBilgileri = $db->getirTek("modul_vatan_sms_ayarlar", ["an_tip" => "api_bilgileri"]);
        $getApiBilgileri = (!empty($getApiBilgileri["an_deger"])) ? json_decode($getApiBilgileri["an_deger"]) : null;

        $api_kullanici_adi = ($getApiBilgileri) ? $getApiBilgileri->api_kullanici_adi : "";
        $api_sifre = ($getApiBilgileri) ? $getApiBilgileri->api_sifre : "";
        $api_sms_basligi = ($getApiBilgileri) ? $getApiBilgileri->api_sms_basligi : "";

        $ekran = "<form method='post'>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<h6 class='sub-title'>API Entegrasyon Bilgileri</h6>";
        $ekran .= "</div>";
        $ekran .= "<div class='col-md-6'>";
        $ekran .= "<label>API Kullanıcı Adı</label>";
        $ekran .= "<input class='form-control' type='text' name='api_kullanici_adi' value='{$api_kullanici_adi}' />";
        $ekran .= "</div>";
        $ekran .= "<div class='col-md-6'>";
        $ekran .= "<label>API Şifre</label>";
        $ekran .= "<input class='form-control' type='text' name='api_sifre' value='{$api_sifre}' />";
        $ekran .= "</div>";
        $ekran .= "<div class='col-md-12'>";
        $ekran .= "<label>API SMS Başlığı</label>";
        $ekran .= "<input class='form-control' type='text' name='api_sms_basligi' value='{$api_sms_basligi}' />";
        $ekran .= "</div>";
        $ekran .= "</div>";
        $ekran .= "<div class='row'>";
        $ekran .= "<div class='col-md-12 mt-2'><button class='btn btn-danger'>Kaydet</button></div>";
        $ekran .= "</div>";
        $ekran .= "</form>";
        echo $ekran;
    }

    public static function SmsGonder($data)
    {
        global $db;
        $sms_telefon = $data["sms_telefon"];
        $sms_icerik = $data["sms_icerik"];
        $api_kullanici_adi_kontrol = $db->getirTek("modul_vatan_sms_ayarlar", ["an_tip" => "api_bilgileri"]);
        $apiBilgileri = json_decode($api_kullanici_adi_kontrol["an_deger"]);

        $curl = curl_init();


        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.vatansms.net/api/v1/1toN',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode(array(
                'api_id' => $apiBilgileri->api_kullanici_adi,
                'api_key' => $apiBilgileri->api_sifre,
                'sender' => $apiBilgileri->api_sms_basligi,
                'message_type' => "normal",
                'message' => $sms_icerik,
                'phones' => [
                    "{$sms_telefon}"
                ]
            )),
        ));

        $response = curl_exec($curl);
        $resp = json_decode($response);

        if ($resp->status == "success") {
            $msjId = $resp->id;
            return array(
                "durum" => true,
                "mesaj_id" => $msjId,
            );
        } else {
            return array(
                "durum" => false,
                "mesaj_aciklama" => $resp->description
            );
        }

        curl_close($curl);
        echo $response;
    }

    public static function DataAktar($data_id)
    {
        global $db;
        $sipQry = "select *,kf.kf_ent as kf_ent,kf.kf_kod as satici, akf.kf_kod as branch_code from siparisler as sp
                                                 left join adres_sehirler as ash on ash.sehir_id = sp.sp_sehir  
                                                 left join adres_ilceler as ai on ai.ilce_id = sp.sp_ilce  
                                                 left join adres_mahalleler as am on am.mah_id = sp.sp_mahalle  
                                                 left join adres_cad_sok as acs on acs.cs_id = sp.sp_cad_sok  
                                                 left join kargo_firmalari as kf on kf.kf_id = sp_kargo  
                                                 left join kargo_firmalari as akf on akf.kf_id = sp_alt_kargo  
                                                 where sp_id = " . $data_id;
        $sp = $db->sorguGetir($sipQry)[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);
        $adresText = "";
        if (!empty($sp->mah_adi))
            $adresText .= $sp->mah_adi;
        if (!empty($sp->cs_adi))
            $adresText .= $sp->cs_adi;
        $adresText .= $sp->sp_adres;
        // Kargo datası oluşturuluyor

        // Ürünler
        $urunler = $db->sorguGetir("select * from siparisler_urunler as sipu 
                                                            join urunler as u on sipu.su_urun_id = u.urun_id
                                                            join urunler_birimler as u_b on sipu.su_birim_id = u_b.ub_id
                                                            where su_siparis_id = {$sp->sp_id}");
        $sp_urun_adet_ad_secenek = "";
        foreach ($urunler as $urun) {
            $urun_baslik = $urun["urun_baslik"];
            $urun_adet = $urun["su_adet"];
            $urun_birim = $urun["ub_baslik"];
            $sp_urun_secenek = "";
            $u_varyasyonlar = (!empty($urun["su_varyasyonlar"]) || $urun["su_varyasyonlar"] != "") ? @array_keys(json_decode($urun["su_varyasyonlar"], true)) : null;
            $u_varyasyonlar_degerler = json_decode($urun["su_varyasyonlar"], true);
            $u_varyasyonlar_string = "";
            for ($ad = 0; $ad < $urun_adet; $ad++) {
                if (!empty($u_varyasyonlar_degerler)) {
                    for ($vary = 0; $vary < count($u_varyasyonlar_degerler); $vary++) {
                        $u_varyasyonlar_string .= $u_varyasyonlar_degerler[$u_varyasyonlar[$vary]][$ad] . " ";
                    }
                    if ($ad + 1 < $urun_adet)
                        $u_varyasyonlar_string .= " , ";
                }
            }
            $sp_urun_adet_ad_secenek .= $urun_adet . " " . $urun_birim . " " . $urun_baslik . " " . $u_varyasyonlar_string;
        }
        // Ürünler

        $barkod = substr($sp->sp_id . time() . rand(1000, 9999), 0, 12);
        $ajannet_ayarlar = $db->getirTek("modul_ajannet_ayarlar", ["an_kod" => $sp->sp_odeme_yontemi, "an_tip" => "odeme_tipi"]);

        $data["customer"] = $sp->sp_musteri;
        //$data["customer"] = "test";
        $data["province_name"] = $sp->sehir_adi;
        $data["county_name"] = $sp->ilce_adi;
        $data["address"] = $adresText;
        $data["telephone"] = $sp->sp_telefon;
        $data["branch_code"] = $sp->branch_code;
        $data["barcode"] = $barkod;
        $data["amount"] = ($sp->sp_siparis_tutari + $sp->sp_kargo_ucreti);
        $data["summary"] = $sp_urun_adet_ad_secenek;
        $data["quantity"] = 1;
        $data["amount_type_id"] = $ajannet_ayarlar["an_deger"];
        $data["order_number"] = $sp->sp_id;
        $data["output_number"] = $sp->sp_id;
        $data["seller"] = $sp->satici;
        // Kargo datası oluşturuluyor

        $url = $ent->URL . "/restapi/client/consignment/add";
        $header = array("Authorization: {$ent->Authorization}", "From: {$ent->From}");
        $user_agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; tr; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.6';
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_USERAGENT, $user_agent);
        curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        $response = curl_exec($curl);
        return $response;
    }

    public static function DataKontrol($data_id)
    {
        global $db;
        $getData = $db->sorguGetir("select * from siparisler as sip 
                                                  left join kargo_firmalari as kf on sip.sp_kargo = kf.kf_id
                                                  join siparisler_kargo_cikislar as skc on sip.sp_kargo_barkod = skc.skc_barkod
                                                  join siparis_durumlari as sd on sip.sp_siparis_durumu = sd.durum_id
                                                  where sp_id = {$data_id}");
        $sp = $getData[0];
        $sp = json_decode(json_encode($sp, true));
        $ent = json_decode($sp->kf_ent);

        if (!empty($getData)) {
            $url = $ent->URL . "/restapi/client/tracking";
            $header = array("Authorization: {$ent->Authorization}", "From: {$ent->From}");
            $user_agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; tr; rv:1.9.0.6) Gecko/2009011913 Firefox/3.0.6';
            $data["barkod"] = $sp->skc_barkod;
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_USERAGENT, $user_agent);
            curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            $response = curl_exec($curl);
            return $response;
        }
    }
}
